/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.ethernet;

import ibm.nways.ethernet.model.RptrGroupModel;
import ibm.nways.jdm.I18NGiblets;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.JdmServerImpl;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.modelgen.StatusMapper;
import ibm.nways.jdm.modelgen.StatusModelInfo;
import ibm.nways.jdm.modelgen.TableStatusNamer;
import java.util.Locale;

public class ActionEthernetRptrGroup
implements StatusMapper,
TableStatusNamer {
    private static String bundleName = "ibm.nways.ethernet.Resources";
    private static String enumBundle = "ibm.nways.ethernet.eui.EnumeratedResources";
    private boolean loggingOn = false;

    public ActionEthernetRptrGroup() {
        String string = JdmServerImpl.getProperty("startLogging");
        if (string != null && string.equals("yes")) {
            this.loggingOn = true;
        }
    }

    public void calculateStatus(StatusModelInfo statusModelInfo, StatusModelInfo statusModelInfo2) {
        try {
            Object[] objectArray = statusModelInfo.getIndexes();
            if (this.loggingOn) {
                System.out.println("ActionEthernetRptrGroup");
                System.out.println("Group = " + objectArray[0]);
                System.out.println("rptrGroupOperStatus = " + statusModelInfo.get("Panel.RptrGroupOperStatus"));
            }
            StatusAndExplain statusAndExplain = this.evaluateStatus((Integer)statusModelInfo.get("Panel.RptrGroupOperStatus"), objectArray);
            statusModelInfo.setStatusType(statusAndExplain.statType, statusAndExplain.explain, true);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public I18NString nameThatObject(StatusModelInfo statusModelInfo) {
        Object[] objectArray = statusModelInfo.getIndexes();
        I18NMsgFormat i18NMsgFormat = new I18NMsgFormat(bundleName, "STATUS_NAME_RPTRGROUP", objectArray);
        return i18NMsgFormat;
    }

    public I18NString nameThatTableObject(StatusModelInfo statusModelInfo) {
        I18NString i18NString = new I18NString(bundleName, "STATUS_TABLE_NAME_RPTRGROUP");
        return i18NString;
    }

    private StatusAndExplain evaluateStatus(int n, Object[] objectArray) {
        StatusAndExplain statusAndExplain = new StatusAndExplain();
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = objectArray[0];
        switch (n) {
            case 1: 
            case 5: 
            case 6: {
                statusAndExplain.statType = StatusType.UNKNOWN;
                objectArray2[1] = new I18NString(enumBundle, RptrGroupModel.Panel.RptrGroupOperStatusEnum.numericToSymbolic(n));
                break;
            }
            case 2: {
                statusAndExplain.statType = StatusType.NORMAL;
                objectArray2[1] = new I18NString(enumBundle, RptrGroupModel.Panel.RptrGroupOperStatusEnum.numericToSymbolic(n));
                break;
            }
            case 3: {
                statusAndExplain.statType = StatusType.CRITICAL;
                objectArray2[1] = new I18NString(enumBundle, RptrGroupModel.Panel.RptrGroupOperStatusEnum.numericToSymbolic(n));
                break;
            }
            case 4: {
                statusAndExplain.statType = StatusType.NONMEMBER;
                objectArray2[1] = new I18NString(enumBundle, RptrGroupModel.Panel.RptrGroupOperStatusEnum.numericToSymbolic(n));
                break;
            }
            default: {
                statusAndExplain.statType = StatusType.UNKNOWN;
                objectArray2[1] = new I18NString(bundleName, "UNEXPECTED_RPTRGROUP_STATUS");
            }
        }
        statusAndExplain.explain = new I18NGiblets(bundleName, "RPTR_GROUP_STATUS_TEXT", objectArray2);
        if (this.loggingOn) {
            System.out.println("ret.statType = " + statusAndExplain.statType);
            int n2 = 0;
            while (n2 < objectArray2.length) {
                if (objectArray2[n2] instanceof I18NString) {
                    System.out.println("moreArgs[" + n2 + "]  bundleName = " + ((I18NString)objectArray2[n2]).getBundleName());
                    System.out.println("moreArgs[" + n2 + "]  key  = " + ((I18NString)objectArray2[n2]).getKey());
                } else {
                    System.out.println("moreArgs[" + n2 + "] = " + objectArray2[n2].toString());
                }
                ++n2;
            }
            System.out.println("ret.explain = " + statusAndExplain.explain.getTranslation(Locale.getDefault()));
        }
        return statusAndExplain;
    }

    private class StatusAndExplain {
        StatusType statType;
        I18NGiblets explain;

        StatusAndExplain() {
            ActionEthernetRptrGroup.this = ActionEthernetRptrGroup.this;
        }
    }
}

